@extends('layouts.admin')

@section('title', 'Appointments')

@section('content')
<h1 class="h3 mb-4">Appointments</h1>

<div class="card">
    <div class="card-body">
        @if($appointments->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Patient Name</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Preferred Time</th>
                        <th>Doctor</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($appointments as $appointment)
                    <tr>
                        <td>{{ $appointment->name }}</td>
                        <td>{{ $appointment->email }}</td>
                        <td>{{ $appointment->phone }}</td>
                        <td>{{ $appointment->preferred_time->format('M d, Y h:i A') }}</td>
                        <td>{{ $appointment->doctor ? $appointment->doctor->name : 'Any Doctor' }}</td>
                        <td>
                            <span class="badge bg-{{ $appointment->status == 'pending' ? 'warning' : ($appointment->status == 'confirmed' ? 'success' : 'danger') }}">
                                {{ ucfirst($appointment->status) }}
                            </span>
                        </td>
                        <td>{{ $appointment->created_at->format('M d, Y') }}</td>
                        <td>
                            <a href="{{ route('admin.appointments.show', $appointment) }}" class="btn btn-sm btn-primary">
                                <i class="bi bi-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <p class="text-muted mb-0">No appointments found.</p>
        @endif
    </div>
</div>
@endsection



